/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.testtools.FileBasedTestCase;
import org.junit.Test;

public class FileUtilsDirectoryContainsTestCase
extends FileBasedTestCase {
    private File directory1;
    private File directory2;
    private File directory3;
    private File file1;
    private File file1ByRelativeDirectory2;
    private File file2;
    private File file2ByRelativeDirectory1;
    private File file3;
    final File top = FileUtilsDirectoryContainsTestCase.getTestDirectory();

    public FileUtilsDirectoryContainsTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.top.mkdirs();
        this.directory1 = new File(this.top, "directory1");
        this.directory2 = new File(this.top, "directory2");
        this.directory3 = new File(this.directory2, "directory3");
        this.directory1.mkdir();
        this.directory2.mkdir();
        this.directory3.mkdir();
        this.file1 = new File(this.directory1, "file1");
        this.file2 = new File(this.directory2, "file2");
        this.file3 = new File(this.top, "file3");
        this.file1ByRelativeDirectory2 = new File(FileUtilsDirectoryContainsTestCase.getTestDirectory(), "directory2/../directory1/file1");
        this.file2ByRelativeDirectory1 = new File(FileUtilsDirectoryContainsTestCase.getTestDirectory(), "directory1/../directory2/file2");
        FileUtils.touch((File)this.file1);
        FileUtils.touch((File)this.file2);
        FileUtils.touch((File)this.file3);
    }

    protected void tearDown() throws Exception {
        FileUtils.deleteDirectory((File)this.top);
    }

    @Test
    public void testCanonicalPath() throws IOException {
        FileUtilsDirectoryContainsTestCase.assertTrue((boolean)FileUtils.directoryContains((File)this.directory1, (File)this.file1ByRelativeDirectory2));
        FileUtilsDirectoryContainsTestCase.assertTrue((boolean)FileUtils.directoryContains((File)this.directory2, (File)this.file2ByRelativeDirectory1));
        FileUtilsDirectoryContainsTestCase.assertFalse((boolean)FileUtils.directoryContains((File)this.directory1, (File)this.file2ByRelativeDirectory1));
        FileUtilsDirectoryContainsTestCase.assertFalse((boolean)FileUtils.directoryContains((File)this.directory2, (File)this.file1ByRelativeDirectory2));
    }

    @Test
    public void testDirectoryContainsDirectory() throws IOException {
        FileUtilsDirectoryContainsTestCase.assertTrue((boolean)FileUtils.directoryContains((File)this.top, (File)this.directory1));
        FileUtilsDirectoryContainsTestCase.assertTrue((boolean)FileUtils.directoryContains((File)this.top, (File)this.directory2));
        FileUtilsDirectoryContainsTestCase.assertTrue((boolean)FileUtils.directoryContains((File)this.top, (File)this.directory3));
        FileUtilsDirectoryContainsTestCase.assertTrue((boolean)FileUtils.directoryContains((File)this.directory2, (File)this.directory3));
    }

    @Test
    public void testDirectoryContainsFile() throws IOException {
        FileUtilsDirectoryContainsTestCase.assertTrue((boolean)FileUtils.directoryContains((File)this.directory1, (File)this.file1));
        FileUtilsDirectoryContainsTestCase.assertTrue((boolean)FileUtils.directoryContains((File)this.directory2, (File)this.file2));
    }

    @Test
    public void testDirectoryDoesNotContainFile() throws IOException {
        FileUtilsDirectoryContainsTestCase.assertFalse((boolean)FileUtils.directoryContains((File)this.directory1, (File)this.file2));
        FileUtilsDirectoryContainsTestCase.assertFalse((boolean)FileUtils.directoryContains((File)this.directory2, (File)this.file1));
        FileUtilsDirectoryContainsTestCase.assertFalse((boolean)FileUtils.directoryContains((File)this.directory1, (File)this.file3));
        FileUtilsDirectoryContainsTestCase.assertFalse((boolean)FileUtils.directoryContains((File)this.directory2, (File)this.file3));
    }

    @Test
    public void testDirectoryDoesNotContainsDirectory() throws IOException {
        FileUtilsDirectoryContainsTestCase.assertFalse((boolean)FileUtils.directoryContains((File)this.directory1, (File)this.top));
        FileUtilsDirectoryContainsTestCase.assertFalse((boolean)FileUtils.directoryContains((File)this.directory2, (File)this.top));
        FileUtilsDirectoryContainsTestCase.assertFalse((boolean)FileUtils.directoryContains((File)this.directory3, (File)this.top));
        FileUtilsDirectoryContainsTestCase.assertFalse((boolean)FileUtils.directoryContains((File)this.directory3, (File)this.directory2));
    }

    @Test
    public void testDirectoryDoesNotExist() throws IOException {
        File dir = new File("DOESNOTEXIST");
        FileUtilsDirectoryContainsTestCase.assertFalse((boolean)dir.exists());
        try {
            FileUtilsDirectoryContainsTestCase.assertFalse((boolean)FileUtils.directoryContains((File)dir, (File)this.file1));
            FileUtilsDirectoryContainsTestCase.fail((String)("Expected " + IllegalArgumentException.class.getName()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSameFile() throws IOException {
        try {
            FileUtilsDirectoryContainsTestCase.assertTrue((boolean)FileUtils.directoryContains((File)this.file1, (File)this.file1));
            FileUtilsDirectoryContainsTestCase.fail((String)("Expected " + IllegalArgumentException.class.getName()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testFileDoesNotExist() throws IOException {
        FileUtilsDirectoryContainsTestCase.assertFalse((boolean)FileUtils.directoryContains((File)this.top, null));
        File file = new File("DOESNOTEXIST");
        FileUtilsDirectoryContainsTestCase.assertFalse((boolean)file.exists());
        FileUtilsDirectoryContainsTestCase.assertFalse((boolean)FileUtils.directoryContains((File)this.top, (File)file));
    }

    @Test
    public void testFileDoesNotExistBug() throws IOException {
        File file = new File(this.top, "DOESNOTEXIST");
        FileUtilsDirectoryContainsTestCase.assertTrue((String)"Check directory exists", (boolean)this.top.exists());
        FileUtilsDirectoryContainsTestCase.assertFalse((String)"Check file does not exist", (boolean)file.exists());
        FileUtilsDirectoryContainsTestCase.assertFalse((String)"Direcory does not contain unrealized file", (boolean)FileUtils.directoryContains((File)this.top, (File)file));
    }

    @Test
    public void testUnrealizedContainment() throws IOException {
        File dir = new File("DOESNOTEXIST");
        File file = new File(dir, "DOESNOTEXIST2");
        FileUtilsDirectoryContainsTestCase.assertFalse((boolean)dir.exists());
        FileUtilsDirectoryContainsTestCase.assertFalse((boolean)file.exists());
        try {
            FileUtilsDirectoryContainsTestCase.assertTrue((boolean)FileUtils.directoryContains((File)dir, (File)file));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

