/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.ProxyOutputStream;

public class ProxyOutputStreamTest
extends TestCase {
    private ByteArrayOutputStream original;
    private OutputStream proxied;

    protected void setUp() {
        this.original = new ByteArrayOutputStream(){

            public void write(byte[] ba) throws IOException {
                if (ba != null) {
                    super.write(ba);
                }
            }
        };
        this.proxied = new ProxyOutputStream((OutputStream)this.original);
    }

    public void testWrite() throws Exception {
        this.proxied.write(121);
        ProxyOutputStreamTest.assertEquals((int)1, (int)this.original.size());
        ProxyOutputStreamTest.assertEquals((int)121, (int)this.original.toByteArray()[0]);
    }

    public void testWriteNullBaSucceeds() throws Exception {
        byte[] ba = null;
        this.original.write(ba);
        this.proxied.write(ba);
    }
}

