/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.testtools;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;

public abstract class FileBasedTestCase
extends TestCase {
    private static volatile File testDir;

    public FileBasedTestCase(String name) {
        super(name);
    }

    public static File getTestDirectory() {
        if (testDir == null) {
            testDir = new File("test/io/").getAbsoluteFile();
        }
        testDir.mkdirs();
        return testDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createFile(File file, long size) throws IOException {
        if (!file.getParentFile().exists()) {
            throw new IOException("Cannot create file " + file + " as the parent directory does not exist");
        }
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));
        try {
            this.generateTestData(output, size);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
        }
    }

    protected byte[] generateTestData(long size) {
        try {
            ByteArrayOutputStream baout = new ByteArrayOutputStream();
            this.generateTestData((OutputStream)baout, size);
            return baout.toByteArray();
        }
        catch (IOException ioe) {
            throw new RuntimeException("This should never happen: " + ioe.getMessage());
        }
    }

    protected void generateTestData(OutputStream out, long size) throws IOException {
        int i = 0;
        while ((long)i < size) {
            out.write((byte)(i % 127 + 1));
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createLineBasedFile(File file, String[] data) throws IOException {
        if (file.getParentFile() != null && !file.getParentFile().exists()) {
            throw new IOException("Cannot create file " + file + " as the parent directory does not exist");
        }
        PrintWriter output = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        try {
            for (String element : data) {
                output.println(element);
            }
        }
        finally {
            IOUtils.closeQuietly((Writer)output);
        }
    }

    protected File newFile(String filename) throws IOException {
        File destination = new File(FileBasedTestCase.getTestDirectory(), filename);
        if (destination.exists()) {
            FileUtils.forceDelete((File)destination);
        }
        return destination;
    }

    protected void checkFile(File file, File referenceFile) throws Exception {
        FileBasedTestCase.assertTrue((String)"Check existence of output file", (boolean)file.exists());
        this.assertEqualContent(referenceFile, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertEqualContent(File f0, File f1) throws IOException {
        FileInputStream is0 = new FileInputStream(f0);
        try {
            FileInputStream is1 = new FileInputStream(f1);
            try {
                byte[] buf0 = new byte[1024];
                byte[] buf1 = new byte[1024];
                int n0 = 0;
                int n1 = 0;
                while (-1 != n0) {
                    n0 = ((InputStream)is0).read(buf0);
                    n1 = ((InputStream)is1).read(buf1);
                    FileBasedTestCase.assertTrue((String)("The files " + f0 + " and " + f1 + " have differing number of bytes available (" + n0 + " vs " + n1 + ")"), (n0 == n1 ? 1 : 0) != 0);
                    FileBasedTestCase.assertTrue((String)("The files " + f0 + " and " + f1 + " have different content"), (boolean)Arrays.equals(buf0, buf1));
                }
            }
            finally {
                ((InputStream)is1).close();
            }
        }
        finally {
            ((InputStream)is0).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertEqualContent(byte[] b0, File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        int numRead = 0;
        byte[] b1 = new byte[b0.length];
        try {
            int count;
            for (count = 0; count < b0.length && numRead >= 0; count += numRead) {
                numRead = ((InputStream)is).read(b1, count, b0.length);
            }
            FileBasedTestCase.assertEquals((String)"Different number of bytes: ", (int)b0.length, (int)count);
            for (int i = 0; i < count; ++i) {
                FileBasedTestCase.assertEquals((String)("byte " + i + " differs"), (byte)b0[i], (byte)b1[i]);
            }
        }
        finally {
            ((InputStream)is).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertEqualContent(char[] c0, File file) throws IOException {
        FileReader ir = new FileReader(file);
        int numRead = 0;
        char[] c1 = new char[c0.length];
        try {
            int count;
            for (count = 0; count < c0.length && numRead >= 0; count += numRead) {
                numRead = ((Reader)ir).read(c1, count, c0.length);
            }
            FileBasedTestCase.assertEquals((String)"Different number of chars: ", (int)c0.length, (int)count);
            for (int i = 0; i < count; ++i) {
                FileBasedTestCase.assertEquals((String)("char " + i + " differs"), (char)c0[i], (char)c1[i]);
            }
        }
        finally {
            ((Reader)ir).close();
        }
    }

    protected void checkWrite(OutputStream output) throws Exception {
        try {
            new PrintStream(output).write(0);
        }
        catch (Throwable t) {
            throw new AssertionFailedError("The copy() method closed the stream when it shouldn't have. " + t.getMessage());
        }
    }

    protected void checkWrite(Writer output) throws Exception {
        try {
            new PrintWriter(output).write(97);
        }
        catch (Throwable t) {
            throw new AssertionFailedError("The copy() method closed the stream when it shouldn't have. " + t.getMessage());
        }
    }

    protected void deleteFile(File file) throws Exception {
        if (file.exists()) {
            FileBasedTestCase.assertTrue((String)("Couldn't delete file: " + file), (boolean)file.delete());
        }
    }
}

