/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.PropertyMap;
import com.healthmarketscience.jackcess.impl.CodecProvider;
import com.healthmarketscience.jackcess.impl.DatabaseImpl;
import com.healthmarketscience.jackcess.impl.PropertyMapImpl;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseBuilder {
    private File _mdbFile;
    private boolean _readOnly;
    private boolean _autoSync = true;
    private Charset _charset;
    private TimeZone _timeZone;
    private CodecProvider _codecProvider;
    private Database.FileFormat _fileFormat;
    private FileChannel _channel;
    private Map<String, PropertyMap.Property> _dbProps;
    private Map<String, PropertyMap.Property> _summaryProps;
    private Map<String, PropertyMap.Property> _userProps;

    public DatabaseBuilder() {
        this(null);
    }

    public DatabaseBuilder(File mdbFile) {
        this._mdbFile = mdbFile;
    }

    public DatabaseBuilder setFile(File mdbFile) {
        this._mdbFile = mdbFile;
        return this;
    }

    public DatabaseBuilder setReadOnly(boolean readOnly) {
        this._readOnly = readOnly;
        return this;
    }

    public DatabaseBuilder setAutoSync(boolean autoSync) {
        this._autoSync = autoSync;
        return this;
    }

    public DatabaseBuilder setCharset(Charset charset) {
        this._charset = charset;
        return this;
    }

    public DatabaseBuilder setTimeZone(TimeZone timeZone) {
        this._timeZone = timeZone;
        return this;
    }

    public DatabaseBuilder setCodecProvider(CodecProvider codecProvider) {
        this._codecProvider = codecProvider;
        return this;
    }

    public DatabaseBuilder setFileFormat(Database.FileFormat fileFormat) {
        this._fileFormat = fileFormat;
        return this;
    }

    public DatabaseBuilder setChannel(FileChannel channel) {
        this._channel = channel;
        return this;
    }

    public DatabaseBuilder putDatabaseProperty(String name, Object value) {
        return this.putDatabaseProperty(name, null, value);
    }

    public DatabaseBuilder putDatabaseProperty(String name, DataType type, Object value) {
        this._dbProps = DatabaseBuilder.putProperty(this._dbProps, name, type, value);
        return this;
    }

    public DatabaseBuilder putSummaryProperty(String name, Object value) {
        return this.putSummaryProperty(name, null, value);
    }

    public DatabaseBuilder putSummaryProperty(String name, DataType type, Object value) {
        this._summaryProps = DatabaseBuilder.putProperty(this._summaryProps, name, type, value);
        return this;
    }

    public DatabaseBuilder putUserDefinedProperty(String name, Object value) {
        return this.putUserDefinedProperty(name, null, value);
    }

    public DatabaseBuilder putUserDefinedProperty(String name, DataType type, Object value) {
        this._userProps = DatabaseBuilder.putProperty(this._userProps, name, type, value);
        return this;
    }

    private static Map<String, PropertyMap.Property> putProperty(Map<String, PropertyMap.Property> props, String name, DataType type, Object value) {
        if (props == null) {
            props = new HashMap<String, PropertyMap.Property>();
        }
        props.put(name, PropertyMapImpl.createProperty(name, type, value));
        return props;
    }

    public Database open() throws IOException {
        return DatabaseImpl.open(this._mdbFile, this._readOnly, this._channel, this._autoSync, this._charset, this._timeZone, this._codecProvider);
    }

    public Database create() throws IOException {
        PropertyMap props;
        DatabaseImpl db = DatabaseImpl.create(this._fileFormat, this._mdbFile, this._channel, this._autoSync, this._charset, this._timeZone);
        if (this._dbProps != null) {
            props = db.getDatabaseProperties();
            props.putAll(this._dbProps.values());
            props.save();
        }
        if (this._summaryProps != null) {
            props = db.getSummaryProperties();
            props.putAll(this._summaryProps.values());
            props.save();
        }
        if (this._userProps != null) {
            props = db.getUserDefinedProperties();
            props.putAll(this._userProps.values());
            props.save();
        }
        return db;
    }

    public static Database open(File mdbFile) throws IOException {
        return new DatabaseBuilder(mdbFile).open();
    }

    public static Database create(Database.FileFormat fileFormat, File mdbFile) throws IOException {
        return new DatabaseBuilder(mdbFile).setFileFormat(fileFormat).create();
    }
}

