/*
 * Decompiled with CFR 0.152.
 */
package tool;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SerialComm {
    static byte[] message = new byte[1024];
    static boolean messagec = false;
    SerialPort serialPort;
    CommPortIdentifier portIdentifier;
    CommPort commPort;
    int BaudRate = 2400;
    int DATABITS = 7;
    int STOPBITS = 1;
    int PARITY = 2;

    public void setBaudRate(int baudRate) {
        this.BaudRate = baudRate;
    }

    public void setDATABITS(int dATABITS) {
        this.DATABITS = dATABITS;
    }

    public void setSTOPBITS(int sTOPBITS) {
        this.STOPBITS = sTOPBITS;
    }

    public void setPARITY(int pARITY) {
        this.PARITY = pARITY;
    }

    public void stop() {
        this.serialPort.close();
        this.serialPort = null;
        this.portIdentifier = null;
        this.commPort.close();
        this.commPort = null;
        System.gc();
    }

    public static boolean getMessagec() {
        return messagec;
    }

    public static byte[] getMessage() {
        return message;
    }

    public static void delMessagec() {
        messagec = false;
    }

    public SerialPort getSerialPort() {
        return this.serialPort;
    }

    public void connect(String portName) throws Exception {
        try {
            this.portIdentifier = CommPortIdentifier.getPortIdentifier((String)portName);
        }
        catch (NoSuchPortException ex) {
            System.out.println(portName + " port \u4e0d\u5b58\u5728\u5594!!");
            this.stop();
            System.out.println((Object)ex);
        }
        if (this.portIdentifier.isCurrentlyOwned()) {
            System.out.println("Error: Port is currently in use");
        } else {
            this.commPort = this.portIdentifier.open(this.getClass().getName(), 2000);
            if (this.commPort instanceof SerialPort) {
                this.serialPort = (SerialPort)this.commPort;
                System.out.println("portName=" + portName);
                System.out.println("BaudRate=" + this.BaudRate);
                System.out.println("DATABITS=" + this.DATABITS);
                System.out.println("STOPBITS=" + this.STOPBITS);
                System.out.println("PARITY=" + this.PARITY);
                this.serialPort.setSerialPortParams(this.BaudRate, this.DATABITS, this.STOPBITS, this.PARITY);
                InputStream in = this.serialPort.getInputStream();
                OutputStream out = this.serialPort.getOutputStream();
                this.serialPort.addEventListener((SerialPortEventListener)new SerialReader(in));
                this.serialPort.notifyOnDataAvailable(true);
            } else {
                System.out.println("Error: Only serial ports are handled by this example.");
            }
        }
    }

    public static class SerialReader
    implements SerialPortEventListener {
        private InputStream in;
        private byte[] buffer = new byte[1024];

        public SerialReader(InputStream in) {
            this.in = in;
        }

        public void serialEvent(SerialPortEvent arg0) {
            try {
                int data;
                int len = 0;
                while ((data = this.in.read()) > -1) {
                    if (data == 4 && this.buffer[len - 1] != 5) {
                        this.buffer[len++] = (byte)data;
                        break;
                    }
                    this.buffer[len++] = (byte)data;
                }
                message = this.buffer;
                messagec = true;
                System.out.println("--------------------------");
                System.out.println("\u8f38\u5165");
                System.out.println("--------------------------");
                System.out.println("\u6578\u91cf  " + len + "      \u524d");
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(-1);
            }
        }
    }
}

